<?php
 
// Generates 3 sidebars
if ( function_exists('register_sidebars') ) {
   register_sidebars(3,array(
       'before_widget' => '<ul id="%1$s" class="widget">',
       'after_widget' => '</ul>',
       'before_title' => '<h3>',
       'after_title' => '</h3>',
   ));
} ?>
<?php
add_filter('comments_template', 'legacy_comments');
function legacy_comments($file) {
	if(!function_exists('wp_list_comments')) 	$file = TEMPLATEPATH . '/legacy.comments.php';
	return $file;
}
?>
<?php
// Generates Custom Fields
function get_custom_field_value($szKey, $bPrint = false) {
	global $post;
	$szValue = get_post_meta($post->ID, $szKey, true);
	if ( $bPrint == false ) return $szValue; else echo $szValue;
} 

// Code for Themes Option Page
function yam_addThemePage() {

	global $bmTheme;

	if ( $_GET['page'] == basename(__FILE__) ) {
	
	    // save settings
		if ( 'save' == $_REQUEST['action'] ) {
		
			check_admin_referer( 'save-theme-properties' );

			// text input
      update_option( 'feedmail', $_REQUEST[ 'feedmail' ] );
      update_option( 'yam_feedlinkURL', $_REQUEST[ 'yam_feedlinkURL' ] );
			update_option( 'yam_feedlinkComments', $_REQUEST[ 'yam_feedlinkComments' ] );
			update_option( 'yam_analytics', $_REQUEST[ 'yam_analytics' ] );
      update_option( 'yam_block1', $_REQUEST[ 'yam_block1' ] );
      update_option( 'yam_block2', $_REQUEST[ 'yam_block2' ] );
      update_option( 'yam_block3', $_REQUEST[ 'yam_block3' ] );
      update_option( 'yam_block4', $_REQUEST[ 'yam_block4' ] );
	  update_option( 'yam_block5', $_REQUEST[ 'yam_block5' ] );
	  update_option( 'yam_block6', $_REQUEST[ 'yam_block6' ] );
	  update_option( 'yam_block7', $_REQUEST[ 'yam_block7' ] );
	  update_option( 'yam_block8', $_REQUEST[ 'yam_block8' ] );

			// goto theme edit page
			header("Location: themes.php?page=functions.php&saved=true");
			die;

  		// reset settings
		} else if( 'reset' == $_REQUEST['action'] ) {

      delete_option( 'yam_block1' );
      delete_option( 'yam_block2' );
      delete_option( 'yam_block3' );
      delete_option( 'yam_block4' );
			delete_option( 'feedmail' );
			delete_option( 'yam_feedlinkURL' );
			delete_option( 'yam_feedlinkComments' );
			delete_option( 'yam_analytics' );
		 
 
			// goto theme edit page
			header("Location: themes.php?page=functions.php&reset=true");
			die;
		}
	}

	add_theme_page( $bmTheme . ' Theme Options', $bmTheme . '', 'edit_themes', basename(__FILE__), 'yam_themePage' );

}

function yam_themePage() {
	global $bmTheme;
	include( "scripts/yam_helpers.php" );
	if ( $_REQUEST[ 'saved' ] ) echo '<div id="message" class="updated fade"><p><strong>Settings saved</strong></p></div>';
	if ( $_REQUEST[ 'reset' ] ) echo '<div id="message" class="updated fade"><p><strong>Settings reset</strong></p></div>';
	
	?>
	<?php
}

function yam_getProperty( $property ) {
	global $bmTheme;
	$value = get_settings( "bmTheme_" . $property );
	if( $value == "1" ) { return 1; } else { return 0; }	
}

$yam_trackbacks	= array();
$yam_comments	= array();

function yam_splitComments( $source ) {
	if ( $source ) {
		global $yam_trackbacks;
		global $yam_comments;
	 	foreach ( $source as $comment ) {
		if ( $comment->comment_type == 'trackback' || $comment->comment_type == 'pingback' ) {	
				$yam_trackbacks[] = $comment;
	  		} else {
	  			$yam_comments[] = $comment;
	  		}
		}
	}

}

function yam_catProperties( $id ) {
	global $yam_categories;
	forEach( $yam_categories as $bC ) {
			if( $bC->cat_ID == $id ) {
			return $bC;
			exit;
		}
	
	}

}

// based upon the work done by Steve Smith - http://orderedlist.com/wordpress-plugins/feedburner-plugin/ and feedburner - http://www.feedburner.com/fb/a/help/wordpress_quickstart
function feed_redirect() {

	global $wp, $feed, $withcomments;
	
	$newURL1 = trim( get_settings( "feedmail" ) );
	$newURL1 = trim( get_settings( "yam_feedlinkURL" ) );
	$newURL2 = trim( get_settings( "yam_feedlinkComments" ) );
	
	if( is_feed() ) {

		if ( $feed != 'comments-rss2' 
				&& !is_single() 
				&& $wp->query_vars[ 'category_name' ] == ''
				&& !is_author() 
				&& ( $withcomments != 1 )
				&& $newURL1 != '' ) {
		
			if ( function_exists( 'status_header' ) ) { status_header( 302 ); }
			header( "Location:" . $newURL1 );
			header( "HTTP/1.1 302 Temporary Redirect" );
			exit();
			
		} elseif ( ( $feed == 'comments-rss2' || $withcomments == 1 ) && $newURL2 != '' ) {
	
			if ( function_exists( 'status_header' ) ) { status_header( 302 ); }
			header( "Location:" . $newURL2 );
			header( "HTTP/1.1 302 Temporary Redirect" );
			exit();
			
		}
	
	}

}

function feed_check_url() {

	switch ( basename( $_SERVER[ 'PHP_SELF' ] ) ) {
		case 'wp-rss.php':
		case 'wp-rss2.php':
		case 'wp-atom.php':
		case 'wp-rdf.php':
		
			$newURL = trim( get_settings( "yam_feedlinkURL" ) );
			
			if ( $newURL != '' ) {
				if ( function_exists('status_header') ) { status_header( 302 ); }
				header( "Location:" . $newURL );
				header( "HTTP/1.1 302 Temporary Redirect" );
				exit();
			}
			
			break;
			
		case 'wp-commentsrss2.php':
		
			$newURL = trim( get_settings( "yam_feedlinkComments" ) );
			
			if ( $newURL != '' ) {
				if ( function_exists('status_header') ) { status_header( 302 ); }
				header( "Location:" . $newURL );
				header( "HTTP/1.1 302 Temporary Redirect" );
				exit();
			}
			
			break;
	}
}

if (!preg_match("/feedburner|feedvalidator/i", $_SERVER['HTTP_USER_AGENT'])) {
	add_action('template_redirect', 'feed_redirect');
	add_action('init','feed_check_url');
}
add_action( 'admin_menu', 'yam_addThemePage' );



function yamidoo() {
    //Check if the admin form has been submited
    if(isset($_POST['submitted']) && $_POST['submitted'] == "yes"){
        //Get form data
		
		$add1 = $_POST['add1'];
		$add2 = $_POST['add2'];
		$add3 = $_POST['add3'];
		$add4 = $_POST['add4'];
		$add5 = $_POST['add5'];
		$add6 = $_POST['add6'];
		$feedmail = $_POST['feedmail'];
		
		$add_url_1 = $_POST['add_url_1'];
		$add_url_2 = $_POST['add_url_2'];
		$add_url_3 = $_POST['add_url_3'];
		$add_url_4 = $_POST['add_url_4'];
		$add_url_5 = $_POST['add_url_5'];
		$add_url_5 = $_POST['add_url_5'];
		$add_url_6 = $_POST['add_url_6'];
	 	
		update_option("add1", $add1);
		update_option("add2", $add2);
		update_option("add3", $add3);
		update_option("add4", $add4);
		update_option("add5", $add5);
		update_option("add6", $add6);
		update_option("feedmail", $feedmail);
		
		update_option("add_url_1", $add_url_1);
		update_option("add_url_2", $add_url_2);
		update_option("add_url_3", $add_url_3);
		update_option("add_url_4", $add_url_4);
		update_option("add_url_5", $add_url_5);
		update_option("add_url_6", $add_url_6);
	 
        echo "<div id=\"message\" class=\"updated fade\"><p><strong>Your settings have been saved.</strong></p></div>";
    }
?>

<div class="wrap">	
<form method="post" target="_self">
 
		<div class="settings">

	
 
	
	<?php if ( function_exists('wp_nonce_field') ) { wp_nonce_field( 'save-theme-properties' ); } ?>
	
	<h3>Blog Settings</h3>
		<div class="item">
			
			<div class="left"><p>Some general blog settings to set up the layout of your site</p></div>

	<table width="100%" cellspacing="2" cellpadding="5" class="editform form-table">
	
	     <tr valign="top"><th width="33%" scope="row">FeedBurner ID for email subscriptions</th><td>
<input type="text" name="feedmail" id="feedmail" value="<?php echo get_option('feedmail'); ?>" /><p style="margin: 0pt; font-size: 0.9em; color: rgb(153, 153, 153);">Only the NAME of your FeedBurner ID, but not the URL.</p></td></tr>
 
			
	<?php
 

		// --------------		
		// Other settings
		// --------------	

		yam_th( "Feedburner URL" );
		yam_input( "yam_feedlinkURL", "text", "Optional Feedburner URL. Will replace rss feed links if used", get_settings( "yam_feedlinkURL" ) );
		yam_cth();
		
		
		yam_th( "Feedburner Comments URL" );
		yam_input( "yam_feedlinkComments", "text", "Optional Feedburner id. Will replace rss comment feed links if used", get_settings( "yam_feedlinkComments" ) );
		yam_cth();
		
		yam_th( "Google Analytics ID" );
		yam_input( "yam_analytics", "text", "Optional Google Analytics ID", get_settings( "yam_analytics" ) );
		yam_cth();		
		
	?>
	</table>

	<h3>Homepage Settings</h3>	
	<p>Homepage specific settings. These control the content shown on the first page of your site.</p>

	<table width="100%" cellspacing="2" cellpadding="5" class="editform form-table">
	<?php 

		$yam_categories = get_categories('hide_empty=0');
		foreach ( $yam_categories as $b ) {
			$yam_cat[] = array( $b->cat_ID, $b->cat_name );
		}

		yam_th( "Featured Category 1" );
		yam_select( "yam_block1", $yam_cat, get_settings( "yam_block1" ), "" );		
		yam_cth();
 
 	yam_th( "Featured Category 2" );
		yam_select( "yam_block2", $yam_cat, get_settings( "yam_block2" ), "" );		
		yam_cth();
 
 	yam_th( "Featured Category 3" );
		yam_select( "yam_block3", $yam_cat, get_settings( "yam_block3" ), "" );		
		yam_cth();
 
 	yam_th( "Featured Category 4" );
		yam_select( "yam_block4", $yam_cat, get_settings( "yam_block4" ), "" );		
		yam_cth();
		
 yam_th( "Featured Category 5" );
		yam_select( "yam_block5", $yam_cat, get_settings( "yam_block5" ), "" );		
		yam_cth();
		
 yam_th( "Featured Category 6" );
		yam_select( "yam_block6", $yam_cat, get_settings( "yam_block6" ), "" );		
		yam_cth();
		
		yam_th( "Featured Category 7" );
		yam_select( "yam_block7", $yam_cat, get_settings( "yam_block7" ), "" );		
		yam_cth();
		
		yam_th( "Featured Category 8" );
		yam_select( "yam_block8", $yam_cat, get_settings( "yam_block8" ), "" );		
		yam_cth();
		
	?>
	</table>	
	
	
 <p class="submit">	<input type="hidden" name="action" value="save" />
	
	<?php yam_input( "save", "submit", "", "Save Settings" ); ?>
	
	</p></form>
	
	<form method="post" target="_self">
 	<div class="settings">
		<h3>Ad Management</h3>
			<div class="item">
					<div class="left">
				 				<span>This section is for the 6 <strong>125 x 125</strong> advertisements in the sidebar.</span><br />
				<span><strong>Usage Example:</strong></span>
				<span>The <strong>add image location</strong> would be <?php bloginfo('template_directory');?>/images/125.jpg that is if your add image is in the <strong>adds</strong> folder!</span>
				
			</div>
			
			<div class="right">
				<label for="add1">Add <strong>1</strong> Image Location: </label>
				<input type="text" name="add1" id="add1" value="<?php echo get_option('add1'); ?>" />
				<label for="add_url_1">Add <strong>1</strong> Url Link: </label>
				<input tyep="text" name="add_url_1" id="add_url_1" value="<?php echo get_option('add_url_1'); ?>" />
			</div>
			
  		<div class="right">
				<label for="add2">Add <strong>2</strong> Image Location: </label>
				<input type="text" name="add2" id="add2" value="<?php echo get_option('add2'); ?>" />
				<label for="add_url_2">Add <strong>2</strong> Url Link: </label>
				<input tyep="text" name="add_url_2" id="add_url_2" value="<?php echo get_option('add_url_2'); ?>" />
			</div>
			
			<div class="right">
				<label for="add3">Add <strong>3</strong> Image Location: </label>
				<input type="text" name="add3" id="add3" value="<?php echo get_option('add3'); ?>" />
				<label for="add_url_3">Add <strong>3</strong> Url Link: </label>
				<input tyep="text" name="add_url_3" id="add_url_3" value="<?php echo get_option('add_url_3'); ?>" />
			</div>
			
			<div class="right">
				<label for="add4">Add <strong>4</strong> Image Location: </label>
				<input type="text" name="add4" id="add4" value="<?php echo get_option('add4'); ?>" />
				<label for="add_url_4">Add <strong>4</strong> Url Link: </label>
				<input tyep="text" name="add_url_4" id="add_url_4" value="<?php echo get_option('add_url_4'); ?>" />
			</div>
			
			<div class="right">
				<label for="add5">Add <strong>5</strong> Image Location: </label>
				<input type="text" name="add5" id="add5" value="<?php echo get_option('add5'); ?>" />
				<label for="add_url_5">Add <strong>5</strong> Url Link: </label>
				<input tyep="text" name="add_url_5" id="add_url_5" value="<?php echo get_option('add_url_5'); ?>" />
			</div>
			
			<div class="right">
				<label for="add6">Add <strong>6</strong> Image Location: </label>
				<input type="text" name="add6" id="add6" value="<?php echo get_option('add6'); ?>" />
				<label for="add_url_6">Add <strong>6</strong> Url Link: </label>
				<input tyep="text" name="add_url_6" id="add_url_6" value="<?php echo get_option('add_url_6'); ?>" />
			</div>
			
			<div class="clear"></div>
			
		</div>
		
	</div>
	

<p class="submit">
<input name="submitted" type="hidden" value="yes" />
<input type="submit" name="Submit" value="Save Settings" />
</p>
</form></div>
<?php 
}

//Add the options page under the Options tab in the admin panel
function yamidoo_settings_page() {
	add_theme_page(__('Yamidoo Theme Options'), __('Yamidoo Theme Options'), 'edit_themes', basename(__FILE__), 'Yamidoo');
}

add_action('admin_menu', 'yamidoo_settings_page');

function yamidoo_style() {
	echo 
		"<style type='text/css'>
		
			.settings h3 { margin: 20px 0 0 0; background: #D7ECFC; border: solid 10px #D7ECFC; font-family: 'Georgia', 'Times New Roman'; font-size: 20px; letter-spacing: -1px; color: #42505A; font-weight: normal; }
			.settings .item { background: #EDF6FC; padding: 15px; margin-bottom: 2px; margin-top: 2px; }
			.settings .item .left { width: 200px; color: #000000; font-size: 17px; letter-spacing: -1px; float: left; }
			.settings .item .left span { display: block; letter-spacing: 0px; font-size: 11px; line-height: 14px; margin-top: 4px;}
			.settings .item .right { width: 700px; float: right; }
			.settings .item .right input, .settings .item .right select { margin-bottom: 15px; width: 300px; background: #ffffff; border: solid 1px #D3DBE0; padding: 4px; display: block; }
			.settings .item .right label { display: block; margin-bottom: 5px; }
			.settings .item .right #mailsubject { margin-bottom: 15px; }
			.settings .item .right textarea { width: 300px; background: #ffffff; border: solid 1px #D3DBE0; padding: 4px; height: 100px; }
			.settings .item .right small { margin-bottom: 15px; display: block; }
			.atention { background: #FFFBE7; padding: 15px; border: dashed 3px #F1DE86; margin-top: 20px; }
		
		</style>";
}

add_action('admin_head', 'yamidoo_style');


  

 
/*
Plugin Name: Limit Posts
Plugin URI: http://labitacora.net/comunBlog/limit-post.phps
Description: Limits the displayed text length on the index page entries and generates a link to a page to read the full content if its bigger than the selected maximum length.
Usage: the_content_limit($max_charaters, $more_link)
Version: 1.1
Author: Alfonso Sanchez-Paus Diaz y Julian Simon de Castro
Author URI: http://labitacora.net/
License: GPL
Download URL: http://labitacora.net/comunBlog/limit-post.phps
Make:
    In file index.php
    replace the_content()
    with the_content_limit(1000, "more")
*/

function the_content_limit($max_char, $more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
    $content = get_the_content($more_link_text, $stripteaser, $more_file);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    $content = strip_tags($content);

   if (strlen($_GET['p']) > 0) {
      echo "<div>";
      echo $content;
      echo "</div>";
   }
   else if ((strlen($content)>$max_char) && ($espacio = strpos($content, " ", $max_char ))) {
        $content = substr($content, 0, $espacio);
        $content = $content;
        echo "<div>";
        echo $content;
        echo "...";
        echo "</div>";
   }
   else {
      echo "<div>";
      echo $content;
      echo "</div>";
   }
}

 
/*
Plugin Name: WordPress Related Posts
Version: 1.0
Plugin URI: http://fairyfish.net/2007/09/12/wordpress-23-related-posts-plugin/
Description: Generate a related posts list via tags of WordPress
Author: Denis
Author URI: http://fairyfish.net/

Copyright (c) 2007
Released under the GPL license
http://www.gnu.org/licenses/gpl.txt

    This file is part of WordPress.
    WordPress is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	INSTALL: 
	Just install the plugin in your blog and activate
*/

add_action('init', 'init_textdomain');
function init_textdomain(){
  load_plugin_textdomain('wp_related_posts',PLUGINDIR . '/' . dirname(plugin_basename (__FILE__)) . '/lang');
}

function wp_get_related_posts() {
	global $wpdb, $post,$table_prefix;
	$wp_rp = get_option("wp_rp");
	
	$exclude = explode(",",$wp_rp["wp_rp_exclude"]);
	$limit = $wp_rp["wp_rp_limit"];
	$wp_rp_title = $wp_rp["wp_rp_title"];
	$wp_no_rp = $wp_rp["wp_no_rp"];
	$wp_no_rp_text = $wp_rp["wp_no_rp_text"];
	$show_date = $wp_rp["wp_rp_date"];
	$show_comments_count = $wp_rp["wp_rp_comments"];
	
	if ( $exclude != '' ) {
		$q = "SELECT tt.term_id FROM ". $table_prefix ."term_taxonomy tt, " . $table_prefix . "term_relationships tr WHERE tt.taxonomy = 'category' AND tt.term_taxonomy_id = tr.term_taxonomy_id AND tr.object_id = $post->ID";

		$cats = $wpdb->get_results($q);
		
		foreach(($cats) as $cat) {
			if (in_array($cat->term_id, $exclude) != false){
				return;
			}
		}
	}
		
	if(!$post->ID){return;}
	$now = current_time('mysql', 1);
	$tags = wp_get_post_tags($post->ID);

	//print_r($tags);
	
	$taglist = "'" . $tags[0]->term_id. "'";
	
	$tagcount = count($tags);
	if ($tagcount > 1) {
		for ($i = 1; $i <= $tagcount; $i++) {
			$taglist = $taglist . ", '" . $tags[$i]->term_id . "'";
		}
	}
		
	if ($limit) {
		$limitclause = "LIMIT $limit";
	}	else {
		$limitclause = "LIMIT 10";
	}
	
	$q = "SELECT p.ID, p.post_title, p.post_date, p.comment_count, count(t_r.object_id) as cnt FROM $wpdb->term_taxonomy t_t, $wpdb->term_relationships t_r, $wpdb->posts p WHERE t_t.taxonomy ='post_tag' AND t_t.term_taxonomy_id = t_r.term_taxonomy_id AND t_r.object_id  = p.ID AND (t_t.term_id IN ($taglist)) AND p.ID != $post->ID AND p.post_status = 'publish' AND p.post_date_gmt < '$now' GROUP BY t_r.object_id ORDER BY cnt DESC, p.post_date_gmt DESC $limitclause;";

	//echo $q;

	$related_posts = $wpdb->get_results($q);
	$output = "";
	
	if (!$related_posts){
		
		if(!$wp_no_rp || ($wp_no_rp == "popularity" && !function_exists('akpc_most_popular'))) $wp_no_rp = "text";
		
		if($wp_no_rp == "text"){
			if(!$wp_no_rp_text) $wp_no_rp_text= __("No Related Post",'wp_related_posts');
			$output  .= '<li>'.$wp_no_rp_text .'</li>';
		}	else{
			if($wp_no_rp == "random"){
				if(!$wp_no_rp_text) $wp_no_rp_text= __("Random Posts",'wp_related_posts');
				$related_posts = wp_get_random_posts($limitclause);
			}	elseif($wp_no_rp == "commented"){
				if(!$wp_no_rp_text) $wp_no_rp_text= __("Most Commented Posts",'wp_related_posts');
				$related_posts = wp_get_most_commented_posts($limitclause);
			}	elseif($wp_no_rp == "popularity"){
				if(!$wp_no_rp_text) $wp_no_rp_text= __("Most Popular Posts",'wp_related_posts');
				$related_posts = wp_get_most_popular_posts($limitclause);
			}else{
				return __("Something wrong",'wp_related_posts');;
			}
			$wp_rp_title = $wp_no_rp_text;
		}
	}		
		
	foreach ($related_posts as $related_post ){
		$output .= '<li>';
		
		if ($show_date){
			$dateformat = get_option('date_format');
			$output .=   mysql2date($dateformat, $related_post->post_date) . " -- ";
		}
		
		$output .=  '<a href="'.get_permalink($related_post->ID).'" title="'.wptexturize($related_post->post_title).'">'.wptexturize($related_post->post_title).'';
		
		if ($show_comments_count){
			$output .=  " (" . $related_post->comment_count . ")";
		}
		
		$output .=  '</a></li>';
	}
	
	$output = '<ul class="related_post">' . $output . '</ul>';
		
	if($wp_rp_title != '') $output =  '<h3>'.$wp_rp_title .'</h3>'. $output;
	
	return $output;
}

function wp_related_posts(){
		
	$output = wp_get_related_posts() ;

	echo $output;
}

function wp23_related_posts() {
	wp_related_posts();
}

function wp_related_posts_for_feed($content=""){
	$wp_rp = get_option("wp_rp");
	$wp_rp_rss = ($wp_rp["wp_rp_rss"] == 'yes') ? 1 : 0;
	if ( (! is_feed()) || (! $wp_rp_rss)) return $content;
	
	$output = wp_get_related_posts() ;
	$content = $content . $output;
	
	return $content;
}

add_filter('the_content', 'wp_related_posts_for_feed',1);

function wp_related_posts_auto($content=""){
	$wp_rp = get_option("wp_rp");
	$wp_rp_auto = ($wp_rp["wp_rp_auto"] == 'yes') ? 1 : 0;
	if ( (! is_single()) || (! $wp_rp_auto)) return $content;
	
	$output = wp_get_related_posts() ;
	$content = $content . $output;
	
	return $content;
}

add_filter('the_content', 'wp_related_posts_auto',99);

function wp_get_random_posts ($limitclause="") {
    global $wpdb, $tableposts, $post;
		
    $q = "SELECT ID, post_title, post_date, comment_count FROM $tableposts WHERE post_status = 'publish' AND post_type = 'post' AND ID != $post->ID ORDER BY RAND() $limitclause";
    return $wpdb->get_results($q);
}

function wp_random_posts ($number = 10){
	$limitclause="LIMIT " . $number;
	$random_posts = wp_get_random_posts ($limitclause);
	
	foreach ($random_posts as $random_post ){
		$output .= '<li>';
		
		$output .=  '<a href="'.get_permalink($random_post->ID).'" title="'.wptexturize($random_post->post_title).'">'.wptexturize($random_post->post_title).'</a></li>';
	}
	
	$output = '<ul class="randome_post">' . $output . '</ul>';
	
	echo $output;
}

function wp_get_most_commented_posts($limitclause="") {
	global $wpdb; 
    $q = "SELECT ID, post_title, post_date, COUNT($wpdb->comments.comment_post_ID) AS 'comment_count' FROM $wpdb->posts, $wpdb->comments WHERE comment_approved = '1' AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status = 'publish' GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC $limitclause"; 
    return $wpdb->get_results($q);
} 

function wp_most_commented_posts ($number = 10){
	$limitclause="LIMIT " . $number;
	$most_commented_posts = wp_get_most_commented_posts ($limitclause);
	
	foreach ($most_commented_posts as $most_commented_post ){
		$output .= '<li>';
		
		$output .=  '<a href="'.get_permalink($most_commented_post->ID).'" title="'.wptexturize($most_commented_post->post_title).'">'.wptexturize($most_commented_post->post_title).'</a></li>';
	}
	
	$output = '<ul class="most_commented_post">' . $output . '</ul>';
	
	echo $output;
}

function wp_get_most_popular_posts ($limitclause="") {
    global $wpdb, $table_prefix;
		
    $q = $sql = "SELECT p.ID, p.post_title, p.post_date, p.comment_count FROM ". $table_prefix ."ak_popularity as akpc,".$table_prefix ."posts as p WHERE p.ID = akpc.post_id ORDER BY akpc.total DESC $limitclause";;
    return $wpdb->get_results($q);
}

function wp_most_popular_posts ($number = 10){
	$limitclause="LIMIT " . $number;
	$most_popular_posts = wp_get_most_popular_posts ($limitclause);
	
	foreach ($most_popular_posts as $most_popular_post ){
		$output .= '<li>';
		
		$output .=  '<a href="'.get_permalink($most_popular_post->ID).'" title="'.wptexturize($most_popular_post->post_title).'">'.wptexturize($most_popular_post->post_title).'</a></li>';
	}
	
	$output = '<ul class="most_popular_post">' . $output . '</ul>';
	
	echo $output;
}

add_action('admin_menu', 'wp_add_related_posts_options_page');

function wp_add_related_posts_options_page() {
	if (function_exists('add_options_page')) {
		add_options_page( __('WordPress Related Posts','wp_related_posts'), __('WordPress Related Posts','wp_related_posts'), 8, basename(__FILE__), 'wp_related_posts_options_subpanel');
	}
}

function wp_related_posts_options_subpanel() {
	if($_POST["wp_rp_Submit"]){
		$message = "WordPress Related Posts Setting Updated";
	
		$wp_rp_saved = get_option("wp_rp");
	
		$wp_rp = array (
			"wp_rp_title" 	=> $_POST['wp_rp_title_option'],
			"wp_no_rp"		=> $_POST['wp_no_rp_option'],
			"wp_no_rp_text"	=> $_POST['wp_no_rp_text_option'],
			"wp_rp_limit"	=> $_POST['wp_rp_limit_option'],
			'wp_rp_exclude'	=> $_POST['wp_rp_exclude_option'],
			'wp_rp_auto'	=> $_POST['wp_rp_auto_option'],
			'wp_rp_rss'		=> $_POST['wp_rp_rss_option'],
			'wp_rp_comments'=> $_POST['wp_rp_comments_option'],
			'wp_rp_date'	=> $_POST['wp_rp_date_option']
		);
		
		if ($wp_rp_saved != $wp_rp)
			if(!update_option("wp_rp",$wp_rp))
				$message = "Update Failed";
		
		echo '<div id="message" class="updated fade"><p>'.$message.'.</p></div>';
	}
	
	$wp_rp = get_option("wp_rp");
?>
    <div class="wrap">
        <h2 id="write-post"><?php _e("Related Posts Options&hellip;",'wp_related_posts');?></h2>
        <p><?php _e("WordPress Related Posts Plugin will generate a related posts via WordPress tags, and add the related posts to feed.",'wp_related_posts');?></p>
        <div style="float:right;">
          <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
          <input type="hidden" name="cmd" value="_donations">
          <input type="hidden" name="business" value="honghua.deng@gmail.com">
          <input type="hidden" name="item_name" value="Donate to fairyfish.net">
          <input type="hidden" name="no_shipping" value="0">
          <input type="hidden" name="no_note" value="1">
          <input type="hidden" name="currency_code" value="USD">
          <input type="hidden" name="tax" value="0">
          <input type="hidden" name="lc" value="US">
          <input type="hidden" name="bn" value="PP-DonationsBF">
          <input type="image" src="https://www.paypal.com/en_US/i/btn/btn_donate_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">
          <img alt="" border="0" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1"><br />
          </form>
        </div>
        <h3><?php _e("Related Posts Preference",'wp_related_posts');?></h3>
        <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?page=<?php echo basename(__FILE__); ?>">
        
        <table class="form-table">
          <tr>
            <th><?php _e("Related Posts Title:",'wp_related_posts'); ?></th>
            <td>
              <input type="text" name="wp_rp_title_option" value="<?php echo $wp_rp["wp_rp_title"]; ?>" />
            </td>
          </tr>
          <tr>
            <th><?php _e("When No Related Posts, Dispaly:",'wp_related_posts'); ?></th>
            <td>
              <?php $wp_no_rp = $wp_rp["wp_no_rp"]; ?>
              <select name="wp_no_rp_option" >
              <option value="text" <?php if($wp_no_rp == 'text') echo 'selected' ?> ><?php _e("Text: 'No Related Posts'",'wp_related_posts'); ?></option>
              <option value="random" <?php if($wp_no_rp == 'random') echo 'selected' ?>><?php _e("Random Posts",'wp_related_posts'); ?></option>
              <option value="commented" <?php if($wp_no_rp == 'commented') echo 'selected' ?>><?php _e("Most Commented Posts",'wp_related_posts'); ?></option>
              <?php if (function_exists('akpc_most_popular')){ ?>
              <option value="popularity" <?php if($wp_no_rp == 'popularity') echo 'selected' ?>><?php _e("Most Popular Posts",'wp_related_posts'); ?></option>
              <?php } ?> 
              </select>
            </td>
          </tr>
          <tr>
            <th><?php _e("No Related Post's Title or Text:",'wp_related_posts'); ?></th>
            <td>
              <input type="text" name="wp_no_rp_text_option" value="<?php echo $wp_rp["wp_no_rp_text"]; ?>" />
            </td>
          </tr>
          <tr>
            <th><?php _e("Limit:",'wp_related_posts');?></th>
            <td>
              <input type="text" name="wp_rp_limit_option" value="<?php echo $wp_rp["wp_rp_limit"]; ?>" />
            </td>
          </tr>
          <tr>
            <th><?php _e("Exclude(category IDs):",'wp_related_posts');?></th>
            <td>
              <input type="text" name="wp_rp_exclude_option" value="<?php echo $wp_rp["wp_rp_exclude"]; ?>" />
            </td>
          </tr>
          <tr>
            <th><?php _e("Other Setting:",'wp_related_posts');?></th>
            <td>
              <label>
              <?php
              if ( $wp_rp["wp_rp_auto"] == 'yes' ) {
              echo '<input name="wp_rp_auto_option" type="checkbox" value="yes" checked>';
              } else {
              echo '<input name="wp_rp_auto_option" type="checkbox" value="yes">';
              }
              ?>
              <?php _e("Auto Insert Related Posts",'wp_related_posts');?>
              </label>
              <br />
              <label>
              <?php
              if ( $wp_rp["wp_rp_rss"] == 'yes' ) {
                echo '<input name="wp_rp_rss_option" type="checkbox" value="yes" checked>';
              } else {
                echo '<input name="wp_rp_rss_option" type="checkbox" value="yes">';
              }
              ?>
              <?php _e("Related Posts for RSS",'wp_related_posts');?>
              </label>
              <br />
              <label>
              <?php
              if ( $wp_rp["wp_rp_comments"] == 'yes' ) {
                echo '<input name="wp_rp_comments_option" type="checkbox" value="yes" checked>';
              } else {
                echo '<input name="wp_rp_comments_option" type="checkbox" value="yes">';
              }
              ?>
              <?php _e("Display Comments Count",'wp_related_posts');?>
              </label>
              <br />
              <label>
              <?php
              if ( $wp_rp["wp_rp_date"] == 'yes' ) {
                echo '<input name="wp_rp_date_option" type="checkbox" value="yes" checked>';
              } else {
                echo '<input name="wp_rp_date_option" type="checkbox" value="yes">';
              }
              ?>
              <?php _e("Display Post Date",'wp_related_posts');?>
              </label>
              <br />
            </td>
          </tr>
        </table>
        <p class="submit"><input type="submit" value="<?php _e("Update Preferences &raquo;",'wp_related_posts');?>" name="wp_rp_Submit" /></p>
        </form>
      </div>
<?php }?>