/* AJAX */

function getXMLHTTPRequest()
{
    var req = false;
    try
    {
        req = new XMLHttpRequest();
    }
    catch (exception1)
    {
        try
        {
            req = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch (exception2)
        {
            try
            {
                req = new ActiveXObject("Microsoft.XMLHTTP");
            }
            catch (exception3)
            {
                req = false;
            }
        }
    }
    return req;
}

/* GLOBAL */

var reqMedicamente = false;
var reqReteta = false;
var reqAdaugare = false;
var reqAdaugareIdElement = 0;
var reqStergere = false;
var timerMedicamente = false;
var pagina = 1;
var sortare = 1;

/* FUNCTII SITE */

function cautaMedicament()
{
    clearTimeout(timerMedicamente);
    timerMedicamente = setTimeout("requestMedicamente()", 1000);
    if (sortare == 1)
    {
        document.getElementById('sortPret').style.fontWeight = "bold";
        document.getElementById('sortDenumire').style.fontWeight = "normal";
    }
    else
    {
        document.getElementById('sortPret').style.fontWeight = "normal";
        document.getElementById('sortDenumire').style.fontWeight = "bold";
    }
}

function requestMedicamente()
{
    var inputFiltru = document.getElementById("text_cautat");
    var divFiltru = document.getElementById("msg_filtru");
    var selectDataLista = document.getElementById("data_lista");
    var nrmed = 10;
    var selectNrMed = document.getElementById("nrmed");
    switch (selectNrMed.selectedIndex)
    {
        case 0: nrmed = 10; break;
        case 1: nrmed = 25; break;
        case 2: nrmed = 50; break;
        case 3: nrmed = 100; break;
    }
    divFiltru.style.display = "";
    reqMedicamente = getXMLHTTPRequest();
    var urlRequest = "scripts/service.php";
    reqMedicamente.open("POST", urlRequest, true);
    reqMedicamente.onreadystatechange = getMedicamente;
    reqMedicamente.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    reqMedicamente.send("func=getListaMedicamente&data_lista=" + selectDataLista.value +
                        "&pagina_tabel=" + String(pagina) +
                        "&nrmed=" + String(nrmed) +
                        "&sortare=" + String(sortare) +
                        "&filtru=" + String(inputFiltru.value));
}

function getMedicamente()
{
    if (reqMedicamente.readyState == 4)
    {
        if (reqMedicamente.status == 200)
        {
            var divFiltru = document.getElementById("msg_filtru");
            divFiltru.style.display = "none";
            var div = document.getElementById('lista_medicamente');
            var response = reqMedicamente.responseText;
            div.innerHTML = response;
        }
    }
}

function requestReteta()
{
    reqReteta = getXMLHTTPRequest();
    var urlRequest = "scripts/service.php";
    reqReteta.open("POST", urlRequest, true);
    reqReteta.onreadystatechange = getReteta;
    reqReteta.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    reqReteta.send("func=getReteta");
}

function getReteta()
{
    if (reqReteta.readyState == 4)
    {
        if (reqReteta.status == 200)
        {
            var div = document.getElementById('reteta');
            var response = reqReteta.responseText;
            div.innerHTML = response;
        }
    }
}

function adaugaMedicament(nIdCompensare)
{
    var editCantitate = document.getElementById('cant' + String(nIdCompensare));
    if (editCantitate.value > 0)
    {
        reqAdaugare = getXMLHTTPRequest();
        reqAdaugareIdElement = nIdCompensare;
        var url = "scripts/service.php";
        reqAdaugare.open("POST", url, true);
        reqAdaugare.onreadystatechange = doAfterAdaugare;
        reqAdaugare.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        reqAdaugare.send("func=adaugaMedicament&id=" + String(nIdCompensare) + "&cant=" + editCantitate.value);
        editCantitate.value = "";
    }
    else
    {
        editCantitate.style.borderColor = 'red';
        editCantitate.style.borderWidth = '2px';
        editCantitate.style.borderStyle = 'solid';
        setTimeout("document.getElementById('cant" + String(nIdCompensare) + "').style.border='';", 1000);
    }
}

function doAfterAdaugare()
{
    if (reqAdaugare.readyState == 4)
    {
        if (reqAdaugare.status == 200)
        {
            var editCantitate = document.getElementById('cant' + String(reqAdaugareIdElement));
            editCantitate.borderStyle = 'none';
            editCantitate.value = '';
            requestReteta();
        }
    }
}

function stergeMedicament(nIdReteta)
{
    if (!confirm("Sigur doriţi să ştergeţi acest medicament de pe reţetă?")) return;
    reqStergere = getXMLHTTPRequest();
    var url = "scripts/service.php";
    reqStergere.open("POST", url, true);
    reqStergere.onreadystatechange = doAfterStergere;
    reqStergere.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    reqStergere.send("func=stergeReteta&id=" + String(nIdReteta));
}

function stergeReteta()
{
    if (!confirm("Sigur doriţi să ştergeţi toate medicamentele de pe reţetă?")) return;
    reqStergere = getXMLHTTPRequest();
    var url = "scripts/service.php";
    reqStergere.open("POST", url, true);
    reqStergere.onreadystatechange = doAfterStergere;
    reqStergere.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    reqStergere.send("func=stergeReteta");
}

function doAfterStergere()
{
    if (reqStergere.readyState == 4)
    {
        if (reqStergere.status == 200)
        {
            requestReteta();
        }
    }
}