# Ninja Forms
[Contributors](https://github.com/wpninjas/ninja-forms/graphs/contributors)

Tags: form, forms, contact form, custom form, form builder, form creator, form manager, form creation, contact forms, custom forms, forms builder, forms creator, forms manager, forms creation, form administration,
Requires at least: 3.8
Tested up to: 4.2.2
Stable tag: 2.9.33
License: GPLv2 or later

Forms created with a simple drag and drop interface. Contact forms, Email collection forms, or any other form you want on your WordPress site.

## Description
Ninja Forms is the ultimate FREE form creation solution for WordPress. Build WordPress Forms within minutes using Ninja Forms powerful forms creation page. It allows you to easily and quickly design complex forms through a drag and drop interface and absolutely no code. But for you developers it has a ton of hooks and filters so you can do absolutely anything with this powerful form building framework.

This [review of Ninja Forms](http://www.youtube.com/watch?v=hVfPmKzqYpk) was done by Pippin Williamson:


Here are just a few of the things you will find in Ninja Forms:

* Custom input masks allow you to restrict user input in your forms for things like phone numbers, currency, and dates.
* Manage, Edit, and Export form user submissions.
* Save fields as favorites and re-use them in multiple forms.
* Export and Import forms and favorite fields.
* Set required fields.
* Add a datepicker to text fields.
* Email form results to any number of pre-determined email addresses, as well as specific messages to the user filling out the form.
* Customize form emails with the WordPress editor.
* Anti-Spam field.
* Extremely developer friendly.
* Submit your form by reloading the page or asynchronously with AJAX.
* Please note that if you are using a version of PHP lower than 5.3, you may experience some problems using AJAX Submissions. These can be minimized by using simple success/error messages without any quotes or special characters.

## Demo Site
Please feel free to visit our [demo site](http://demo.ninjaforms.com/) where you can test the features of Ninja Forms and all of our extensions.

## Extensions

* [PayPal Express](http://ninjaforms.com/downloads/paypal-express/) - Accept payments using PayPal Express and Ninja Forms!
* [Front-End Editor](http://ninjaforms.com/downloads/front-end-editor/) - Give your users the ability to create, edit, or delete posts, pages, or any custom post type and allow your users to edit their Ninja Forms submissions all from the front-end. Also included is front-end profile editing, custom registration forms, login and password resetting, all without needing to see the default, WordPress branded login page.
* [File Uploads](http://ninjaforms.com/downloads/file-uploads/) - Allow users to upload files and store those files within a searchable database.
* [Multi-Part Forms](http://ninjaforms.com/downloads/multi-part-forms/) - Break up those long, complex forms into multiple pages.
* [Save User Progress](http://ninjaforms.com/downloads/save-user-progress/) - Let your users save their progress and return later to finish filling out the form.
* [Conditional Logic](http://ninjaforms.com/downloads/conditional-logic/) - Create "smart" forms that show or hide fields based upon user input. Even add a value to a dropdown list when a user selects a specific value from another list.
* [Front-End Posting](http://ninjaforms.com/downloads/front-end-posting/) - Use Ninja Forms to create posts from the front-end. These can be added to any post type, including custom post types, and users can select categories and tags.
* [Layout & Styles](http://ninjaforms.com/downloads/layout-styles/) - Use Ninja Forms to create amzing form layouts and styles right from your WordPress admin.
* [MailChimp](http://ninjaforms.com/downloads/mail-chimp/) - The MailChimp extension allows you to quickly create newsletter signup forms for your MailChimp account using the power and flexibility that Ninja Forms provides.
* [Campaign Monitor](http://ninjaforms.com/downloads/campaign-monitor/) - The Campaign Monitor extension allows you to quickly create newsletter signup forms for your Campaign Monitor account using the power and flexibility that Ninja Forms provides.
* [User Analytics](http://ninjaforms.com/downloads/user-analytics/) - The User Analytics extension will help website owners understand how hot a lead is based on extra data automatically collected about the user.
* [Constant Contact](http://ninjaforms.com/downloads/constant-contact/) - The Constant Contact extension allows you to quickly create newsletter signup forms for your Constant Contact account using the power and flexibility that Ninja Forms provides.
* [Pushover](http://ninjaforms.com/downloads/pushover/) - When email and SMS notifications just do not cut it, send yourself push notifications of form submissions with Pushover. Pushover makes it easy to send real-time notifications to your Android and iOS devices.
* [Freshbooks](http://ninjaforms.com/downloads/freshbooks/) - Automatically insert Ninja Forms data right into Freshbooks when your potential clients submit forms. Go from lead to invoice that much quicker by having the information already in your favorite invoicing application.

We have several other extensions in the works.

If you're a developer and would like to talk about creating some premium extensions for Ninja Forms, send us an email: info@wpninjas.com.

## Contributing

If you're a developer and want to help make Ninja Forms better, you're in the right place! We know contributing to a project can be intimidating; sometimes it’s hard to tell how to get involved. We believe Ninja Forms is a perfect community to get involved in. In our experience, everyone involved with the project has been amazing and helpful. :)
So here are some [friendly guidelines](https://github.com/wpninjas/ninja-forms/blob/master/CONTRIBUTING.md).

__Please Note:__ GitHub is for bug reports and contributions only - if you have a support question or a request for a customisation, go to our [Ninja Forms Support](http://ninjaforms.com/documentation/using-ninja-forms/faq-troubleshooting/) instead.

## Screenshots

To see up to date screenshots, visit [Ninja Forms.com](http://ninjaforms.com/).

## Installation

This section describes how to install the plugin and get it working.

1. Upload the `ninja-forms` directory to your `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Visit the 'Forms' menu item in your admin sidebar

Shortcodes have been re-implemented. They are used like so: `[ninja_forms_display_form id=3]` where 3 is the ID number of the form you want to display.

## Use

For help and video tutorials, please visit our website: [Ninja Forms Documentation](http://ninjaforms.com/documentation/intro/)

## Requested Features

If you have any feature requests, please feel free to visit [ninjaforms.com](http://ninjaforms.com) and let us know about it.
