<?php
/*
Plugin Name: Vivacity Plugin
Plugin URI: 
Description: A required plugin for the Vivacity theme you purchased from ThemeForest. It includes a number of features that you can still use if you switch to another theme.
Version: 1.1
Author: GhostPool
Author URI: http://themeforest.net/user/GhostPool/portfolio?ref=GhostPool
License: You should have purchased a license from ThemeForest.net
*/

if ( ! class_exists( 'GP_Vivacity' ) ) {

	class GP_Vivacity {

		public function __construct() {

			if ( ! class_exists( 'CustomSidebars' ) ) {
				require_once( sprintf( "%s/custom-sidebars/custom-sidebars.php", dirname( __FILE__ ) ) );
			}
						
			if ( ! class_exists( 'Widget_Importer_Exporter' ) ) {
				require_once( sprintf( "%s/widget-importer-exporter/widget-importer-exporter.php", dirname( __FILE__ ) ) );
			}

			if ( ! post_type_exists( 'portfolio' ) ) {
				require_once( sprintf( "%s/post-types/portfolio.php", dirname( __FILE__ ) ) );
				$GP_Portfolio = new GP_Portfolio();
			}

			if ( ! post_type_exists( 'slide' ) && !class_exists('GP_Slides')) {
				require_once( sprintf( "%s/post-types/slide.php", dirname( __FILE__ ) ) );
				$GP_Slides = new GP_Slides();
			}
												
		} 
		
		public static function gp_activate() {} 		
		public static function gp_deactivate() {}
		
	}
	
}

if ( class_exists( 'GP_Vivacity' ) ) {

	register_activation_hook( __FILE__, array( 'GP_Vivacity', 'gp_activate' ) );
	register_deactivation_hook( __FILE__, array( 'GP_Vivacity', 'gp_deactivate' ) );

	$ghostpool = new GP_Vivacity();

}

?>