<?php

add_action( 'widgets_init', 'gp_recent_comments' );

function gp_recent_comments() {
	register_widget( 'GP_Recent_Comments' );
}

class GP_Recent_Comments extends WP_Widget {

	function GP_Recent_Comments() {
		$widget_ops = array( 'classname' => 'gp-recent-comments', 'description' => __( 'Your site\'s most recent comments with avatars.', 'gp_lang' ) );
		$this->WP_Widget( 'gp-recent-comments-widget', __( 'GP Recent Comments', 'gp_lang' ), $widget_ops );
	}

	function widget( $args, $instance ) {
	
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );				
		$comment_number = $instance['comment_number'];
		
		global $comment;
	
		echo $before_widget;
			
		?>

		<?php if ( $title ) { echo $before_title . $title . $after_title; } ?>

		<?php 
		
		$args = array( 
		'number' => $comment_number,
		'status' => 'approve',
		 );

		$comments = get_comments( $args );

		if ( $comments ) { ?>
    
			<ul>

				<?php foreach ( $comments as $comment ) { ?>
	 
					<li>
		
						<?php echo get_avatar( $comment->comment_author_email, 32 ); ?> 

						<span>
						
							<strong><?php echo $comment->comment_author; ?> <?php _e( 'said', 'gp_lang' ); ?></strong> <?php echo strip_tags( substr ( apply_filters( 'get_comment_text', $comment->comment_content ), 0, 20 ) ); ?>...<span>
							
							<a href="<?php echo get_comment_link( $comment->comment_ID ); ?>" title="<?php echo( $comment->post_title ); ?>"><?php echo human_time_diff( get_comment_time('U'), current_time('timestamp') ); ?> <?php _e( 'ago', 'gp_lang' ); ?></a></span>
							
						</span>
			
					</li>					

				<?php } ?>
		
			</ul>
		
		<?php } else { ?>

			<?php _e( 'There are no comments to display.', 'gp_lang' ); ?>

		<?php } ?>	
		
		<?php echo $after_widget; 

	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['comment_number'] = $new_instance['comment_number'];
		return $instance;
	}

	function form( $instance ) {
	
		$defaults = array( 
			'title'          => 'Recent Comments',
			'comment_number' => '5',
		 ); $instance = wp_parse_args( ( array ) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'gp_lang' ); ?></label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'comment_number' ); ?>"><?php _e( 'Number of comments to show:', 'gp_lang' ); ?></label>
			<input  type="text" id="<?php echo $this->get_field_id( 'comment_number' ); ?>" name="<?php echo $this->get_field_name( 'comment_number' ); ?>" value="<?php echo $instance['comment_number']; ?>" size="3" />
		</p>
		
		<input type="hidden" name="widget-options" id="widget-options" value="1" />

		<?php

	}
}

?>