<?php require( gp_inc . 'options.php' ); global $gp_settings;

// Get Portfolio Tags
$tags = wp_get_post_tags( get_the_ID() );
$tempQuery = $wp_query;

if ( $tags ) {

	$tag_ids = array();

	foreach ( $tags as $individual_tag ) $tag_ids[] = $individual_tag->term_id;

	$args = array(
	'post_type'           => 'gp_portfolio_item',
	'ignore_sticky_posts' => 0,
	'orderby'             => 'rand',
	'order'               => 'asc',
	'paged'               => 1,
	'posts_per_page'      => $gp_settings['related_per_page'],
	'offset'              => 0,
	'tag__in'             => $tag_ids,
	'post__not_in'        => array( get_the_ID() ),
	); 

	$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) :
	
	// Column Width
	$column_width = ( 100 - ( ( $gp_settings['related_per_page'] * 2 ) - 2) ) / $gp_settings['related_per_page'];
		
	?>
	
		<div class="related-portfolios">
		
			<span class="border-triangle"></span>

			<header class="related-portfolios-title">
				<h3><?php echo _e( 'Related Items', 'gp_lang' ); ?></h3>
			</header><!-- END HEADER -->
	
			<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>

				<article <?php post_class( 'portfolio-loop' ); ?> style="width: <?php echo $column_width; ?>%;">
	
					<div class="post-thumbnail">
				
						<a href="<?php the_permalink(); ?>">	
									
							<?php if ( has_post_thumbnail() ) { ?>	
							
								<?php $image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $gp_settings['related_image_width'], $gp_settings['related_image_height'], true, false, true ); ?>
								
								<?php if ( $gp_retina == 'enable' ) {
									$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $gp_settings['related_image_width'] * 2, $gp_settings['related_image_height'] * 2, true, false, true );
								} else {
									$retina = "";
								} ?>
								
								<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />	

							<?php } else { ?>

								<?php $post_format_class = 'fa-file-o'; ?>
										
								<i class="no-thumbnail fa fa-3x <?php echo $post_format_class; ?>" width="<?php echo $gp_settings['related_image_width']; ?>" width="<?php echo $gp_settings['related_image_height']; ?>" style="width: <?php echo $gp_settings['related_image_width']; ?>px; height: <?php echo $gp_settings['related_image_height']; ?>px; line-height: <?php echo $gp_settings['related_image_height']; ?>px;"></i>	
							
							<?php } ?>
						
						</a>
								
					</div><!-- END FEATURED IMAGE -->

					<header class="entry-header">

						<h5><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h5>

					</header>

				</article><!-- END PORTFOLIO ITEM -->
		
			<?php endwhile; ?>
	
		</div><!-- END RELATED PORTFOLIOS -->

	<?php endif; wp_reset_postdata(); ?>

<?php } ?>