<?php

if ( ! function_exists( 'gp_blog' ) ) {

	function gp_blog( $atts, $content = null ) {
	
		extract( shortcode_atts( array(
			'type' => 'blog-standard',
			'cats' => '', 
			'per_page' => '10',
			'featured_image' => 'enable',
			'image_width' => '700',
			'image_height' => '400',
			'hard_crop' => 'enable',
			'image_wrap' => 'enable',
			'content_display' => 'excerpt',
			'excerpt_length' => '400',
			'read_more' => 'enable',
			'meta_date' => 'enable',
			'meta_author' => 'enable',
			'meta_cats' => 'disable',
			'meta_comments' => 'enable',
			'meta_tags' => 'disable',
			'pages' => 'enable',
			'class' => '',
		), $atts ) );	
		
		global $gp_settings; 
		$gp_settings['featured_image'] = $featured_image;
		$gp_settings['image_width'] = $image_width;
		$gp_settings['image_height'] = $image_height;
		$gp_settings['hard_crop'] = $hard_crop;
		$gp_settings['image_wrap'] = $image_wrap;
		$gp_settings['content_display'] = $content_display;
		$gp_settings['excerpt_length'] = $excerpt_length;
		$gp_settings['read_more'] = $read_more;
		$gp_settings['meta_date'] = $meta_date;
		$gp_settings['meta_author'] = $meta_author;
		$gp_settings['meta_cats'] = $meta_cats;
		$gp_settings['meta_comments'] = $meta_comments;
		$gp_settings['meta_tags'] = $meta_tags;
		
		ob_start();

		if ( get_query_var('paged') ) {
			$paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}
		
		$args = array(
		'post_type'      => 'post',
		'cat' => $cats,
		'posts_per_page' => $per_page,
		'paged'          => $paged,
		);

		$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) : ?>

			<div class="post-wrapper <?php echo $type; ?>">

				<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>

					<?php get_template_part( 'post', 'loop' ); ?>
				
				<?php endwhile; ?>

			</div><!-- END POST WRAPPER -->

			<?php if ( $pages == 'enable' ) { gp_pagination( $featured_query->max_num_pages ); } ?>

		<?php else : ?>

			<span class="error"><?php _e( 'No posts found.', 'gp_lang' ); ?></span>

		<?php endif; wp_reset_postdata(); ?>

		<?php

		$output_string = ob_get_contents();
		ob_end_clean(); 
		return $output_string;
	
	}
	
}
	
add_shortcode( 'blog', 'gp_blog' ); ?>