<?php

/*--------------------------------------------------------------
Set WooCommerce defaults
--------------------------------------------------------------*/

if ( is_admin() && isset( $_GET['wc-installed'] ) && $pagenow == 'index.php' ) {
	if ( get_option( 'gp_wc_defaults' ) !== '1' ) {
		function gp_woocommerce_defaults() {		
			update_option( 'shop_catalog_image_size', array( 'width' => 340, 'height' => 380, 'crop' => 1 ) );
			update_option( 'shop_thumbnail_image_size', array( 'width' => 110, 'height' => 110, 'crop' => 1 ) ); 
			update_option( 'shop_single_image_size', array( 'width' => 500, 'height' => 700, 'crop' => 1 ) );
			update_option( 'woocommerce_frontend_css', 0 );
			update_option( 'woocommerce_enable_lightbox', 1 );
		}	
		add_action( 'init', 'gp_woocommerce_defaults', 1 );	
		update_option( 'gp_wc_defaults', '1' );										
	}		
}
	

/*--------------------------------------------------------------
Enable default WooCommerce styling
--------------------------------------------------------------*/

if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) <= 0 ) {
	define( 'WOOCOMMERCE_USE_CSS', true );
}


/*--------------------------------------------------------------
Columns per shop page
--------------------------------------------------------------*/

if ( ! function_exists( 'gp_loop_columns' ) ) {
	function gp_loop_columns() {
		global $gp_settings;
		if ( $gp_settings['layout'] == 'fullwidth' OR $gp_settings['layout'] == 'no-sidebar' ) {
			return 4;
		} else {
			return 3;
		}
	}
}
add_filter( 'loop_shop_columns', 'gp_loop_columns' );


/*--------------------------------------------------------------
Products per page
--------------------------------------------------------------*/

add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 12;' ), 20 );


/*--------------------------------------------------------------
Product thumbnail columns
--------------------------------------------------------------*/
	
if ( ! function_exists( 'gp_product_thumbnails_columns' ) ) {	
	function gp_product_thumbnails_columns() {
		return 4;
	}
}
add_filter( 'woocommerce_product_thumbnails_columns', 'gp_product_thumbnails_columns' );

			
/*--------------------------------------------------------------
Related products per page
--------------------------------------------------------------*/

if ( ! function_exists( 'woocommerce_output_related_products' ) ) {
	function woocommerce_output_related_products() {
		woocommerce_related_products( 4, 4 ); // Display 4 products in rows of 4
	}
}


/*--------------------------------------------------------------
Pagination
--------------------------------------------------------------*/

remove_action( 'woocommerce_pagination', 'woocommerce_pagination', 10 );
if ( ! function_exists( 'woocommerce_pagination' ) ) {
	function woocommerce_pagination() {
		global $wp_query;
		gp_pagination( $wp_query->max_num_pages );
	}
}	
add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10 );


/*--------------------------------------------------------------
Product Category Images
--------------------------------------------------------------*/

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
 
if ( ! function_exists( 'woocommerce_template_loop_product_thumbnail' ) ) {
	function woocommerce_template_loop_product_thumbnail() {
		echo woocommerce_get_product_thumbnail();
	} 
}
 
if ( ! function_exists( 'woocommerce_get_product_thumbnail' ) ) {
	
	function woocommerce_get_product_thumbnail( $size = 'shop_catalog', $placeholder_width = 0, $placeholder_height = 0 ) {
	
		require( gp_inc . 'options.php' ); global $post, $product, $woocommerce;
 
		if ( !$placeholder_width ) {
			$placeholder_width = get_option( 'shop_catalog_image_size' );
			$placeholder_width = $placeholder_width['width'];
		}
		if ( !$placeholder_height ) {
			$placeholder_height = get_option( 'shop_catalog_image_size' );
			$placeholder_height = $placeholder_height['height'];
		}
		$placeholder_crop = get_option( 'shop_catalog_image_size' );
		$placeholder_crop = $placeholder_crop['crop'];
		
		$output = '';
		
		$output .= '<span class="product-image-container">';
			
			if ( has_post_thumbnail() ) {

				$attachment_ids = $product->get_gallery_attachment_ids();				
				
				if ( $attachment_ids ) {
					
					foreach ( $attachment_ids as $attachment_id ) {
						if ( $attachment_id != get_post_thumbnail_id() ) {
							$image = aq_resize( wp_get_attachment_url( $attachment_id ), $placeholder_width, $placeholder_height, $placeholder_crop, false, true );					
							if ( $gp_retina == 'enable' ) {
								$retina = aq_resize( wp_get_attachment_url( $attachment_id ), $placeholder_width * 2, $placeholder_height * 2, $placeholder_crop, false, true );
							} else {
								$retina = '';
							}	
						}
					}
			
					$output .= '<img src="' . $image[0] . '" data-rel="' . $retina[0] . '" width="' . $image[1] . '" height="' . $image[2] . '" alt="' . get_the_title( $attachment_id ) . '" class="wp-post-image image-overlay" />';

				}

				$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) ), $placeholder_width, $placeholder_height, $placeholder_crop, false, true );		
				if ( $gp_retina == 'enable' ) {
					$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) ), $placeholder_width * 2, $placeholder_height * 2, $placeholder_crop, false, true );
				} else {
					$retina = '';
				}
		
				$output .= '<img src="' . $image[0] . '" data-rel="' . $retina[0] . '" width="' . $image[1] . '" height="' . $image[2] . '" alt="' . get_the_title( get_post_thumbnail_id() ) . '" class="attachment-shop_catalog wp-post-image" />';			
			
			} else {
		
				$output .= '<img src="' . woocommerce_placeholder_img_src() . '" alt="' . __( 'Placeholder' , 'gp_lang' ) . '" width="' . $placeholder_width . '" height="' . $placeholder_height . '" />';

			}
		
		$output .= '</span>';
		
		return $output;
		
	}
	
}
 

/*--------------------------------------------------------------
Dropdown Cart
--------------------------------------------------------------*/

// Plugin Check
function gp_dropdown_plugin_installed() {
    
	if ( function_exists( 'dropdowncart_scripts' ) ) { ?>
	
		<div class="error"><p><?php _e( 'Woocommerce Dropdown Cart Widget is already built into this theme, please deactivate this plugin.', 'gp_lang' ); ?></p></div>
		
	<?php }
}
add_action( 'admin_notices', 'gp_dropdown_plugin_installed' );

// Dropdown Cart Loop
if ( ! function_exists( 'gp_dropdown_loop' ) ) {

	function gp_dropdown_loop() {
	
		global $woocommerce;

		if ( sizeof( $woocommerce->cart->cart_contents ) > 0 ) {
	
			$i = 0;				
		
			foreach ( $woocommerce->cart->cart_contents as $cart_item_key => $cart_item ) {
	
				$i++;
			
				if ( $i == 1 ) {				
					$rowclass = ' class="cart-oddrow"';			
				} else {
					$rowclass = ' class="cart-evenrow"';
					$i = 0;
				}

				$_product = $cart_item['data'];
	
				if ( $_product->exists() && $cart_item['quantity'] > 0 ) {
		
					echo '<li' . $rowclass . '>';
		
						echo '<a href="' . get_permalink( $cart_item['product_id'] ) . '">';				
				
							if ( has_post_thumbnail( $cart_item['product_id'] ) ) {					
								echo get_the_post_thumbnail( $cart_item['product_id'], 'shop_thumbnail' ); 
							} else {					 
								echo '<img src="' . $woocommerce->plugin_url() . '/assets/images/placeholder.png" alt="Placeholder" width="' . $woocommerce->get_image_size( 'shop_thumbnail_image_width' ) . '" height="' . $woocommerce->get_image_size( 'shop_thumbnail_image_height' ) . '" />'; 				
							}
										
							echo '<span class="dropdowncart-product">';
						
								echo apply_filters( 'woocommerce_cart_widget_product_title', $_product->get_title(), $_product );				
								if ( $_product instanceof woocommerce_product_variation && is_array( $cart_item['variation'] ) ) {
									echo woocommerce_get_formatted_variation( $cart_item['variation'] );
								}
			
								echo '<span class="quantity">' . $cart_item['quantity'] . ' &times; ' . woocommerce_price( $_product->get_price() ) . '</span>';

							echo '</span>';
					
						echo '</a>';
		
					echo '</li>';
			
				}
			
			}
		
		} else {
	 
			echo '<li class="empty">' . __( 'No products in the cart.', 'gp_lang' ) . '</li>'; 
	
		} ?>
					
		<?php if ( sizeof( $woocommerce->cart->cart_contents ) > 0 ) {
	
			echo '<li class="total">';
		
				if ( get_option( 'js_prices_include_tax' ) == 'yes' ) {
					_e( 'Total', 'gp_lang' );
				} else {
					_e( 'Subtotal', 'gp_lang' );
				}

				echo ': ' . $woocommerce->cart->get_cart_total();
		
			echo '</li>';
		
			do_action( 'woocommerce_widget_shopping_cart_before_buttons' );
		
			echo '<li class="dropdowncart-buttons">
				  <a href="' . $woocommerce->cart->get_cart_url() . '"><span class="button ">' . __( 'View Cart', 'gp_lang' ) . '</span></a> <a href="' . $woocommerce->cart->get_checkout_url() . '"><span class="button">' . __( 'Checkout', 'gp_lang' ) . '</span></a>
				  </li>';
		}
			
	}
	
}

// Normal Drop Down Cart
if ( ! function_exists( 'gp_dropdown_cart' ) ) {														
	function gp_dropdown_cart() {
		global $woocommerce;
		if ( ! is_cart() ) { ?>	
			<ul class="dropdowncart menu">
				<li>
					<a href="<?php echo $woocommerce->cart->get_cart_url(); ?>" id="cart-button" title="<?php _e( 'View your shopping cart', 'gp_lang' ); ?>">
						<i class="fa fa-shopping-cart"></i>
						<span class="cart-count"><?php echo sprintf( _n( '%d', '%d', $woocommerce->cart->cart_contents_count, 'gp_lang' ), $woocommerce->cart->cart_contents_count ); ?></span>
					</a>
					<ul class="sub-menu">
						<?php echo gp_dropdown_loop(); ?>			
					</ul>
				</li>
			</ul>
	<?php }
	}
}


// Ajaxify Cart Button
if ( ! function_exists( 'gp_woocommerce_add_to_cart_fragment' ) ) {
	function gp_woocommerce_add_to_cart_fragment( $fragments ) {
		global $woocommerce; ob_start(); ?>
	
			<span class="cart-count"><?php echo sprintf( _n( '%d', '%d', $woocommerce->cart->cart_contents_count, 'gp_lang' ), $woocommerce->cart->cart_contents_count ); ?></span>
	
		<?php $fragments['#cart-button .cart-count'] = ob_get_clean();
		return $fragments;

	}
}
add_filter( 'add_to_cart_fragments', 'gp_woocommerce_add_to_cart_fragment' );

// Ajaxify Dropdwon Cart
if ( ! function_exists( 'gp_woocommerce_dropdown_fragment' ) ) {
	function gp_woocommerce_dropdown_fragment( $fragments ) {
		global $woocommerce; ob_start(); ?>
			<ul class="sub-menu">
				<?php echo gp_dropdown_loop(); ?>			
			</ul>
		<?php $fragments['.dropdowncart .sub-menu'] = ob_get_clean();
		return $fragments;
	}
}
add_filter( 'add_to_cart_fragments', 'gp_woocommerce_dropdown_fragment' );

?>