<?php

if ( ! class_exists( 'GP_Portfolio' ) ) {

	class GP_Portfolio {

		public function __construct() {
			add_action( 'init', array( &$this, 'gp_post_type_portfolio' ) );	
			add_action( 'manage_posts_custom_column',  array( &$this, 'gp_portfolio_custom_columns' ) );
		}

		public function gp_post_type_portfolio() {

			/*--------------------------------------------------------------
			Portfolio Item Post Type
			--------------------------------------------------------------*/	
	
			register_post_type( 'gp_portfolio_item', array( 
				'labels' => array( 
					'name' => __( 'Portfolio Items', 'gp_lang' ),
					'singular_name' => __( 'Portfolio Item', 'gp_lang' ),
					'menu_name' => __( 'Portfolio Items', 'gp_lang' ),
					'all_items' => __( 'All Portfolio Items', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New Portfolio Item', 'gp_lang' ),
					'edit_item' => __( 'Edit Portfolio Item', 'gp_lang' ),
					'new_item' => __( 'New Portfolio Item', 'gp_lang' ),
					'view_item' => __( 'View Portfolio Item', 'gp_lang' ),
					'search_items' => __( 'Search Portfolio Items', 'gp_lang' ),
					'not_found' => __( 'No portfolio items found', 'gp_lang' ),
					'not_found_in_trash' => __( 'No portfolio items found in Trash', 'gp_lang' ),
				 ),
				'public' => true,
				'exclude_from_search' => false,
				'show_ui' => true,
				'show_in_nav_menus' => true,
				'_builtin' => false,
				'_edit_link' => 'post.php?post=%d',
				'capability_type' => 'post',
				'hierarchical' => false,
				'rewrite' => array( 'slug' => get_option( 'gp_portfolio_item_slug' ) ),
				'menu_position' => 20,
				'with_front' => true,
				'taxonomies' => array( 'post_tag' ),
				'has_archive' => get_option( 'gp_portfolio_cat_slug' ),
				'supports' => array( 'title', 'thumbnail', 'editor', 'author', 'comments', 'custom-fields' )
			 ) );
	
	
			/*--------------------------------------------------------------
			Portfolio Categories Taxonomy
			--------------------------------------------------------------*/
			
			register_taxonomy( 'gp_portfolios', 'gp_portfolio_item', array( 
				'labels' => array( 
					'name' => __( 'Portfolio Categories', 'gp_lang' ),
					'singular_name' => __( 'Portfolio Category', 'gp_lang' ),
					'all_items' => __( 'All Portfolio Categories', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New Portfolio Category', 'gp_lang' ),
					'edit_item' => __( 'Edit Portfolio Category', 'gp_lang' ),
					'new_item' => __( 'New Portfolio Category', 'gp_lang' ),
					'view_item' => __( 'View Portfolio Category', 'gp_lang' ),
					'search_items' => __( 'Search Portfolio Categories', 'gp_lang' ),
					'menu_name' => __( 'Portfolio Categories', 'gp_lang' )
				 ),
				'show_in_nav_menus' => true,
				'hierarchical' => true,
				'rewrite' => array( 'slug' => get_option( 'gp_portfolio_cat_slug' ) )
			 ) );


			register_taxonomy_for_object_type( 'gp_portfolios', 'gp_portfolio_item' );


			/*--------------------------------------------------------------
			Portfolio Item Admin Columns
			--------------------------------------------------------------*/

			function gp_portfolio_item_edit_columns( $columns ) {
				$columns = array( 
				'cb'                   => '<input type="checkbox" />',
				'title'                => __( 'Title', 'gp_lang' ),	
				'portfolio_categories' => __( 'Categories', 'gp_lang' ),
				'portfolio_image'      => __( 'Image', 'gp_lang' ),				
				'date'                 => __( 'Date', 'gp_lang' )
				 );
				return $columns;
			}	
			add_filter( 'manage_edit-gp_portfolio_item_columns', 'gp_portfolio_item_edit_columns' );
		
		}

		public function gp_portfolio_custom_columns( $column ) {
			switch ( $column ) {
				case 'portfolio_categories':
					echo get_the_term_list( get_the_ID(), 'gp_portfolios', '', ', ', '' );
				break;
				case 'portfolio_image':
					if ( has_post_thumbnail() ) {
						the_post_thumbnail( array( 50, 50 ) );
					}
				break;					
			}
		}
		
		
	}

}

?>