<?php

class TField
{
	/* FIELD DETAILS */
    public $caption;
    public $fieldName;
    public $selectFieldName;
    public $fieldType;
    public $isPrimaryKey;
    public $isAutoGenerated;
    public $isTreeNode;
    public $isCalculated;
    public $allowNULL;
    
    public $defaultValue;

    protected $internalValue;
    
    /* INTERFACE INFO */
    public $visibleInList;
    public $visibleInForm;
    public $table;
    public $NULLifZero;
    
    /* GRID DATA */
    public $gridWidth;
    public $gridType;
    public $gridAlign;
    public $gridColor;
    public $gridSort;
    public $gridId;
    
    /* PARENT INFO */
    /* If a field has a parent (from a parent-child table relationship), then the
     * parent's value will be used in all queries and it will be saved in the database
     * as the value of the current field
     */   
    public $parentField;

    /* SOURCE TABLE */
    /* This type of table is used when the current field get's it's value from another table (in SQL
     * we say it has a FOREIGN KEY in another table). You will not be able to alter it's value
     * directly, but by choosing a record from a combo box, list or radio group
     */
    public $sourceTable;
    public $sourceSQL;
    public $sourceKeyField;
    public $sourceValueField;
    public $sourceDisplayMode; // select, radio, list
    public $sourceAllowAddNew;
    public $sourceGetAllFields;

    /* DETAIL TABLE */
    /* If a field links to a single child (1-1 relationship), then the child will be shown
     * in the parent's form and they will be saved to the database together
     */
    public $detailTable;
    public $detailKeyField;
    public $detailValueField;

    /* CHILD TABLE */
    /* If a field links to multiple children (1-n relationship), then there children will be shown
     * as a separate table below the parent info. The table will be visible only after the
     * parent is saved
     */
    public $children;
    //public $childTable;
    //public $childKeyField;
    
    /* TREE PARENT FIELD */
    /* If a field is linked to another field in the current tabel in a child-parent relationship,
     * it will be stored here
     */
    public $treeParentField;
 
    // Properties
    
    function __construct()
    {
        $this->gridWidth = "*";
        $this->gridType = "ed";
        $this->gridAlign = "left";
        $this->gridColor = "";
        $this->gridSort = "str";
        
        $this->isTreeNode = false;
        $this->treeParentField = null;
        
        $this->sourceGetAllFields = false;
        
        $this->children = array();
    }
    
    public function __get($property)
    {
    	switch($property)
    	{
    		case "fieldAlias":
                if ($this->table)
    				if ($this->table->tableAlias)
    					return $this->table->tableAlias.'_'.$this->fieldName;
    				else
    					return $this->table->tableName.'_'.$this->fieldName;
    			else
    				return FALSE;
    			break;
            case "value":
                return $this->internalValue;
                break;
            case "sqlValue":
                return "'".$this->internalValue."'";
                break;
            case "formValue":
                return $this->internalValue;
                break;
            case "displayValue":
                if ($this->parentField)
                    return $this->parentField->displayValue;
                elseif ($this->sourceTable)
                {
                    return $this->ParseTableValues($this->sourceTable, $this->sourceValueField);
                }
                elseif ($this->detailTable)
                {
                    return $this->ParseTableValues($this->detailTable, $this->detailValueField);
                }
                else
                    return ($this->internalValue != "")?$this->internalValue:"&nbsp";
                break;
    	}
    }
    
    public function __set($property, $property_value)
    {
        switch($property)
        {
            case "value":
                $this->internalValue = $property_value;
                break;
            case "sqlValue":
                $this->internalValue = $property_value;
                break;
            case "formValue":
                $this->internalValue = getuserdata($this->table->tableAlias.'_'.$this->fieldName);
        }
    }
    
    private function ParseTableValues(TTable $table, $wantedFields)
    {
        if (strpos($wantedFields, ';') === false)
        {
            return $table->fields[$wantedFields]->displayValue;
        }
        else
        {
            $chunks = explode(';', $wantedFields);
            $returnValue = "";
            $i = 0;
            foreach ($chunks as $chunk)
            {
                if (substr($chunk, 0, 1) == '[')
                {
                    $sourceValueFields[$i]['prefix'] = substr($chunk, 1, strpos($chunk, ']') - 1);
                    $chunk = substr($chunk, strpos($chunk, ']') + 1);
                }
                else $sourceValueFields[$i]['prefix'] = ($i)?' ':'';
                if (strpos($chunk, '[') !== false)
                {
                    $sourceValueFields[$i]['suffix'] = str_replace(']', '', substr($chunk, strpos($chunk, '[') + 1));
                    $chunk = substr($chunk, 0, strpos($chunk, '['));
                }
                else $sourceValueFields[$i]['suffix'] = '';
                $sourceValueFields[$i++]['field'] = $chunk;
            }
            foreach ($sourceValueFields as $sourceValueField)
            {
                $returnValue .= $sourceValueField['prefix'].
                                $table->fields[$sourceValueField['field']]->displayValue.
                                $sourceValueField['suffix'];
            }
            return $returnValue;
        }
    }

    public function Show()
    {
        echo $this->GetDisplayValue();
    }

    protected function ShowDetailTableEditor($formFieldName)
    {
        //$this->detailTable->GetDatabaseValues($this->GetValue());
        echo "\n    <div class='clearAll'>&nbsp;</div>";
        echo "\n    <input type='hidden' name='".$this->table->tableName.'_'.$this->fieldName."' value='".$this->formValue."'>";
        echo "\n    <fieldset id='detail_".$this->detailTable->tableName."' class='FieldFieldset'><legend>".$this->caption."</legend>";
        $this->detailTable->ShowEditForm(null, false, $this->detailTable->tableName);
        echo "\n    </fieldset>";
    }

    protected function ShowSourceSQLEditor($formFieldName)
    {

    }

    protected function ShowSourceTableEditor($formFieldName)
    {
        global $scriptroot, $debug;

        if (strpos($this->sourceValueField, ';') === false)
        {
            $selectFieldName = $this->sourceValueField;
            $sourceField = "`".$this->sourceValueField."`";
        }
        else
        {
            $chunks = explode(';', $this->sourceValueField);
            $i = 0;
            $selectFieldName = '';
            foreach ($chunks as $chunk)
            {
                if (substr($chunk, 0, 1) == '[')
                {
                    $sourceValueFields[$i]['prefix'] = substr($chunk, 1, strpos($chunk, ']') - 1);
                    $chunk = substr($chunk, strpos($chunk, ']') + 1);
                }
                else $sourceValueFields[$i]['prefix'] = ($i)?' ':'';
                if (strpos($chunk, '[') !== false)
                {
                    $sourceValueFields[$i]['suffix'] = str_replace(']', '', substr($chunk, strpos($chunk, '[') + 1));
                    $chunk = substr($chunk, 0, strpos($chunk, '['));
                }
                else $sourceValueFields[$i]['suffix'] = '';
                $sourceValueFields[$i++]['field'] = $chunk;
                if ($selectFieldName) $selectFieldName .= '__';
                $selectFieldName .= $chunk;
            }

            $selectExpr = '';
            foreach ($sourceValueFields as $sourceValueField)
            {
                if ($selectExpr) $selectExpr .= ", ";
                            else $selectExpr .= 'CONCAT(';
                if ($sourceValueField['prefix']) $selectExpr .= "'".$sourceValueField['prefix']."', ";
                $selectExpr .= "`".$this->sourceTable->tableName."`.`".$sourceValueField['field']."`";
                if ($sourceValueField['suffix']) $selectExpr .= ", '".$sourceValueField['suffix']."'";
            }
            $sourceField = $selectExpr.") AS `".$selectFieldName."`";
        }

        if (substr($this->sourceDisplayMode, 0, 6) == "select")
        {
            echo "\n    <div id='field_".$formFieldName."' class='TField1'>";
            echo "\n    <label for='".$formFieldName."' id='lbl_".$formFieldName."'";
            if (!$this->allowNULL) echo " class='required'";
            echo ">".$this->caption.":</label>";
            $q = mysql_query("SELECT `".$this->sourceKeyField->fieldName."`, ".$sourceField." FROM `".$this->sourceTable->tableName."`".
                (($this->sourceTable->sqlWhere)?"\nWHERE ".$this->sourceTable->sqlWhere:''));
            if ($debug) echo "<pre>SELECT `".$this->sourceKeyField."`, ".$sourceField." FROM `".$this->sourceTable->tableName."`\n".
                             mysql_error()."</pre>";

            if ($this->sourceAllowAddNew)
            {
                // Butonul de adaugare              
                echo "\n    <a href='#peloc' onclick='editDBItemFromCombo(\"".$this->sourceTable->internalName."\",  \"id = 0\", \"\", \"cmb{$formFieldName}\", 
                                    \"id = 0\", \"".$this->sourceKeyField->fieldName."\", \"".$this->sourceValueField."\")'";
                echo "class='btn_add'";
                echo "><img src='img/combo_add.gif' alt='Add'></a>";
            }

            echo "\n        <select name='".$formFieldName."' id='".$formFieldName."'";
            if ($this->sourceAllowAddNew) echo " class='followed_by_popup'";
            echo ">";
            if ($this->allowNULL)
                if ((int)$this->GetValue() == 0)
                    echo "\n            <option value='0' selected>&nbsp;</option>";
                else
                    echo "\n            <option value='0'>&nbsp;</option>";
            while ($r = mysql_fetch_assoc($q))
            {
                echo "\n            <option value='".$r[$this->sourceKeyField->fieldName]."'";
                if ($this->value == $r[$this->sourceKeyField->fieldName]) echo " selected";
                echo ">".$r[$selectFieldName]."</option>";
            }
            echo "\n        </select>";

            echo "\n        <script type='text/javascript'>";
            echo "\n            var cmb{$formFieldName} = dhtmlXComboFromSelect(\"$formFieldName\");";
            if ($this->sourceDisplayMode == 'select_filter')
                echo "\n            cmb{$formFieldName}.enableFilteringMode(true);";
            echo "\n        </script>";
            echo "\n    </div>";
        }
        elseif ($this->sourceDisplayMode == "radio")
        {
            echo "\n    <fieldset id='radiobox_".$formFieldName."'><legend";
            if (!$this->allowNULL) echo " class='required'";
            echo ">".$this->caption."</legend>";
            if ($this->allowNULL)
                if ((int)$this->GetValue() == 0)
                    echo "\n        <label class='radio_label'><input type='radio' class='radio' name='".$formFieldName."' id='".$formFieldName."_0' value='0' checked> None</label>";
                else
                    echo "\n        <label class='radio_label'><input type='radio' class='radio' name='".$formFieldName."' id='".$formFieldName."_0' value='0'> None</label>";
            $q = mysql_query("SELECT `".$this->sourceKeyField->fieldName."`, ".$sourceField." FROM `".$this->sourceTable->tableName."`");
            while ($r = mysql_fetch_assoc($q))
            {
                echo "\n        <label class='radio_label'><input type='radio' class='radio' name='".$formFieldName."' id='".$formFieldName."_".$r[$this->sourceKeyField->fieldName].
                     "' value='".$r[$this->sourceKeyField->fieldName]."'";
                if ($this->GetValue() == $r[$this->sourceKeyField->fieldName]) echo " checked";
                echo ">".$r[$selectFieldName]."</label>";
            }
            echo "\n    </fieldset>";
        }
    }

    protected function ShowFieldEditor($formFieldName)
    {
        echo "\n    <div id='field_".$formFieldName."' class='TFieldSingleLine'>";
        echo "\n        <div class='dhxlist_txt_label'>";
        echo "\n            <label for='".$formFieldName."' id='lbl_".$formFieldName."'";
        if (!$this->allowNULL) echo " class='required'";
        echo ">".$this->caption.":</label>";
        echo "\n        </div>";
        echo "\n        <div class='dhxlist_cont'>";
        echo "\n            <input type='text' name='".$formFieldName."' id='".$formFieldName."' value='".$this->GetValue()."' class='dhxlist_txt_textarea'>";
        echo "\n        </div>";
        echo "\n    </div>";
    }

    public function ShowEditor()
    {
        $formFieldName = $this->table->tableName.'_'.$this->fieldName;

        if ($this->detailTable)
        {
            $this->ShowDetailTableEditor($formFieldName);
        }
        elseif ($this->sourceSQL)
        {
            $this->ShowSourceSQLEditor($formFieldName);
        }
        elseif ($this->sourceTable)
        {
            $this->ShowSourceTableEditor($formFieldName);
        }
        else
        {
            $this->ShowFieldEditor($formFieldName);
        }
    }

    public function IsValid()
    {
        return true;
    }

    public function SetValue($value)
    {
        $this->value = $value;
    }

    public function GetValue()
    {
        return (($this->parentField)?$this->parentField->GetValue():$this->value);
    }

    public function GetDisplayValue()
    {
        /*if ($this->parentField)
            return $this->parentField->GetDisplayValue();
        elseif ($this->sourceValueField)
            return $this->sourceTable->fields[$this->sourceValueField]->GetDisplayValue();
        elseif ($this->displayValue)
            return $this->displayValue;
        else
            return "&nbsp;";*/



//echo "<pre>P: ".$this->parentField." D: ".$this->detailValueField." V: ".$this->displayValue."</pre>";
/*echo "::DV::";
if ($this->parentField) echo "(".$this->fieldName.")->".$this->parentField->fieldName;
                   else echo "(".$this->fieldName.")->"."[no parent]";
if ($this->sourceValueField) echo "(".$this->fieldName.")->".$this->sourceValueField;
                        else echo "(".$this->fieldName.")->".$this->sourceValueField;*/
        return (($this->parentField)?$this->parentField->GetDisplayValue():
                   /*(($this->detailValueField)?$this->detailTable->fields[$this->detailValueField]->GetDisplayValue():*/
                       (($this->displayValue)?$this->displayValue:'&nbsp;'))/*)*/;
    }

    public function SetDisplayValue($value)
    {
        $this->displayValue = $value;
    }
}

?>