<?php
    require_once("../lang.php");
    require_once("../config.php");
    $lang = $_GET['lang'];
    set_language($lang);
    header("Content-Type: text/javascript");
?>

/* Database Functions */

var ajaxDBRequests = [];
var forms = false;

function centerDiv(obj)
{
    // First, determine how much the visitor has scrolled

    var scrolledX, scrolledY;
    if (window.pageYoffset)
    {
        scrolledX = window.pageXoffset;
        scrolledY = window.pageYoffset;
    }
    else if( document.documentElement && document.documentElement.scrollTop )
    {
        scrolledX = document.documentElement.scrollLeft;
        scrolledY = document.documentElement.scrollTop;
    }
    else if( document.body )
    {
        scrolledX = document.body.scrollLeft;
        scrolledY = document.body.scrollTop;
    }

    // Next, determine the coordinates of the center of browser's window

    var centerX, centerY;
    if (self.innerHeight)
    {
        centerX = self.innerWidth;
        centerY = self.innerHeight;
    }
    else if( document.documentElement && document.documentElement.clientHeight )
    {
        centerX = document.documentElement.clientWidth;
        centerY = document.documentElement.clientHeight;
    }
    else if( document.body )
    {
        centerX = document.body.clientWidth;
        centerY = document.body.clientHeight;
    }

    // Xwidth is the width of the div, Yheight is the height of the
    // div passed as arguments to the function:
    var leftoffset = scrolledX + (centerX - obj.offsetWidth) / 2;
    var topoffset = scrolledY + (centerY - obj.offsetHeight) / 2;
    // The initial width and height of the div can be set in the
    // style sheet with display:none; divid is passed as an argument to // the function
    var r = obj.style;
    r.position = 'absolute';
    r.top = topoffset + 'px';
    r.left = leftoffset + 'px';
    //r.display = "block";
}

function requestFormContent(sender, tableName, sqlWhere, formId, gridId, srcWhere)
{
    var newRequest = getXMLHTTPRequest();
    var newRequester = sender;
    var urlRequest = "edit_dbitem.php";
    newRequest.open("POST", urlRequest, true);
    newRequest.onreadystatechange = getFormContent;
    newRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    newRequest.send("table=" + tableName + "&where=" + sqlWhere + "&form_id=" + formId + "&grid_id=" + gridId + "&srcWhere=" + srcWhere);
    if (ajaxDBRequests != "")
    {
        ajaxDBRequests[ajaxDBRequests.length] = new Array(2);
        ajaxDBRequests[ajaxDBRequests.length][0] = newRequest;
    }
    else
    {
        ajaxDBRequests = new Array(1);
        ajaxDBRequests[0] = new Array(2);
        ajaxDBRequests[0][0] = newRequest;
    }
    ajaxDBRequests[ajaxDBRequests.length - 1][1] = newRequester;
}

function getFormContent()
{
    for (var i = 0; i < ajaxDBRequests.length; i++)
    {
        if (ajaxDBRequests[i][0].readyState == 4)
        {
            if (ajaxDBRequests[i][0].status == 200)
            {
                if (ajaxDBRequests[i][1] != null)
                {
                    var request = ajaxDBRequests[i][0];
                    var component = ajaxDBRequests[i][1];
                    component.innerHTML = request.responseText;
                }
                ajaxDBRequests.splice(i, 1);
            }
            else
            {
                alert('<?=langjs('errRetrData');?>');
            }
        }
    }
}

function editDBItem(table, where, parentFields, grid_id, srcWhere)
{
    if (forms == false)
    {
        forms = new dhtmlXWindows();
        forms.enableAutoViewport(true); //false);
        forms.setImagePath("<?=$scriptroot?>js/dhtmlx/imgs/");
    }
    var cDate = new Date();
    var formId = 'frm' + cDate.getTime();
    eval(formId + "= forms.createWindow('" + formId + "', document.body.clientWidth / 2 - 440, 50, 880, 700);");
    forms.window(formId).progressOn();
    var newContainer = document.createElement("DIV");
    newContainer.innerHTML = "Loading form content...";
    newContainer.style.overflow = "auto";
    newContainer.style.width = "100%";
    newContainer.style.height = "100%";
    newContainer.style.background.color = "#EFEFEF";
    forms.window(formId).attachObject(newContainer);
    forms.window(formId).attachURL("edit_dbitem.php?table=" + table + "&where=" + where + "&form_id=" + formId + "&grid_id=" + grid_id + "&srcWhere=" + srcWhere + "&parent_fields=" + parentFields, true);
    forms.window(formId).progressOff();
}

function editDBItemFromCombo(table, where, parentFields, comboId, srcWhere, keyField, valueField)
{
    if (forms == false)
    {
        forms = new dhtmlXWindows();
        forms.enableAutoViewport(true); //false);
        forms.setImagePath("<?=$scriptroot?>js/dhtmlx/imgs/");
    }
    var cDate = new Date();
    var formId = 'frm' + cDate.getTime();
    eval(formId + "= forms.createWindow('" + formId + "', document.body.clientWidth / 2 - 320, 200, 640, 400);");
    forms.window(formId).progressOn();
    var newContainer = document.createElement("DIV");
    newContainer.innerHTML = "Loading form content...";
    newContainer.style.overflow = "auto";
    newContainer.style.width = "100%";
    newContainer.style.height = "100%";
    newContainer.style.backgroundColor = "#EFEFEF";
    forms.window(formId).attachObject(newContainer);
    forms.window(formId).attachURL("edit_dbitem.php?table=" + table + "&where=" + where + "&form_id=" + formId + "&combo_id=" + comboId + "&srcWhere=" + srcWhere +
        "&keyField=" + keyField + "&valueField=" + valueField, true);
    forms.window(formId).progressOff();
}

function deleteDBItem(table, where, parentFields, grid_id, srcWhere)
{
    if (forms == false)
    {
        forms = new dhtmlXWindows();
        forms.enableAutoViewport(true); //false);
        forms.setImagePath("<?=$scriptroot?>js/dhtmlx/imgs/");
    }
    var cDate = new Date();
    var formId = 'frm' + cDate.getTime();
    eval(formId + "= forms.createWindow('" + formId + "', document.body.clientWidth / 2 - 160, 270, 380, 130);");
    forms.window(formId).button('close').hide();
    forms.window(formId).button('minmax1').hide();
    forms.window(formId).button('minmax2').hide();
    forms.window(formId).button('park').hide();
    forms.window(formId).progressOn();
    var newContainer = document.createElement("DIV");
    newContainer.innerHTML = "Loading form content...";
    newContainer.style.overflow = "hidden";
    newContainer.style.width = "100%";
    newContainer.style.height = "100%";
    forms.window(formId).attachObject(newContainer);
    forms.window(formId).attachURL("delete_dbitem.php?table=" + table + "&where=" + where + "&form_id=" + formId + "&grid_id=" + grid_id + "&srcWhere=" + srcWhere + "&parent_fields=" + parentFields, true);
    forms.window(formId).progressOff();
}

// MINUTES

var ajaxEntryMinuteRequests = [];

function requestEntryMinuteFormContent(sender, id, formId, gridId)
{
    var newRequest = getXMLHTTPRequest();
    var newRequester = sender;
    var urlRequest = "edit_entry_minute.php";
    newRequest.open("POST", urlRequest, true);
    newRequest.onreadystatechange = getEntryMinuteFormContent;
    newRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    newRequest.send("id=" + id + "&form_id=" + formId + "&grid_id=" + gridId);
    if (ajaxEntryMinuteRequests != "")
    {
        ajaxEntryMinuteRequests[ajaxEntryMinuteRequests.length] = new Array(2);
        ajaxEntryMinuteRequests[ajaxEntryMinuteRequests.length][0] = newRequest;
    }
    else
    {
        ajaxEntryMinuteRequests = new Array(1);
        ajaxEntryMinuteRequests[0] = new Array(2);
        ajaxEntryMinuteRequests[0][0] = newRequest;
    }
    ajaxEntryMinuteRequests[ajaxEntryMinuteRequests.length - 1][1] = newRequester;
}

function getEntryMinuteFormContent()
{
    for (var i = 0; i < ajaxEntryMinuteRequests.length; i++)
    {
        if (ajaxEntryMinuteRequests[i][0].readyState == 4)
        {
            if (ajaxEntryMinuteRequests[i][0].status == 200)
            {
                if (ajaxEntryMinuteRequests[i][1] != null)
                {
                    var request = ajaxEntryMinuteRequests[i][0];
                    var component = ajaxEntryMinuteRequests[i][1];
                    component.innerHTML = request.responseText;
                }
                ajaxEntryMinuteRequests.splice(i, 1);
            }
            else
            {
                alert('<?=langjs('errRetrData');?>');
            }
        }
    }
}

function editEntryMinute(id, gridId)
{
    if (forms == false)
    {
        forms = new dhtmlXWindows();
        forms.enableAutoViewport(true); //false);
        forms.setImagePath("<?=$scriptroot?>js/dhtmlx/imgs/");
    }
    var cDate = new Date();
    var formId = 'frm' + cDate.getTime();
    eval(formId + "= forms.createWindow('" + formId + "', document.body.clientWidth / 2 - 440, 50, 880, 700);");
    forms.window(formId).setText('Loading form...');
    var newContainer = document.createElement("DIV");
    newContainer.innerHTML = "Loading form content...";
    newContainer.style.overflow = "auto";
    newContainer.style.width = "100%";
    newContainer.style.height = "100%";
    forms.window(formId).attachObject(newContainer);
    forms.window(formId).attachURL('edit_entry_minute.php?id=' + id, true);
}
