/**
 * $Id: editor_plugin_src.js 539 2008-01-14 19:08:58Z spocke $
 *
 * @author Valentin Istrate
 * @copyright Copyright  2004-2008, Valentin Istrate, All rights reserved.
 */

(function() {
	tinymce.create('tinymce.plugins.ArticleLinkPlugin', {
		init : function(ed, url) {
			this.editor = ed;

			// Register commands
			ed.addCommand('mceArtLink', function() {
				var se = ed.selection;

				// No selection and not in link
				if (se.isCollapsed() && !ed.dom.getParent(se.getNode(), 'A'))
					return;

				ed.windowManager.open({
					file : url + '/link.htm',
					width : 480 + parseInt(ed.getLang('artlink.delta_width', 0)),
					height : 400 + parseInt(ed.getLang('artlink.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});

			// Register buttons
			ed.addButton('artlink', {
				title : 'artlink.link_desc',
				cmd : 'mceArtLink'
			});

			ed.onNodeChange.add(function(ed, cm, n, co) {
				cm.setDisabled('artlink', co && n.nodeName != 'A');
				cm.setActive('artlink', n.nodeName == 'A' && !n.name);
			});
		},

		getInfo : function() {
			return {
				longname : 'Article link',
				author : 'Valentin Istrate',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/artlink',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('artlink', tinymce.plugins.ArticleLinkPlugin);
})();