<?php

    require_once 'autentificare.php';
    require_once 'lang.php';
    set_language('ro-RO');
    require_once 'classes/classes.php';
    //require_once 'lang/en-US.php';

    if (isset($_SESSION['id_concurs'])) $default_id_concurs = $_SESSION['id_concurs']; else $default_id_concurs = 3;

    // concurs_clase
    $tblClaseConcurs = new TTable('tblClaseConcurs');
    $tblClaseConcurs->tableName = "concurs_clase";
    $tblClaseConcurs->name = 'Clase';
    $tblClaseConcurs->AddField("ID", "id", "number", true, true, false, false);
    $tblClaseConcurs->AddField("id_concurs", 'id_concurs', "number");
    $tblClaseConcurs->fields['id_concurs']->defaultValue = $default_id_concurs;
    $tblClaseConcurs->AddField('Clasa', 'clasa', 'string');

    // concurs_sali
    $tblSaliConcurs = new TTable('tblSaliConcurs');
    $tblSaliConcurs->tableName = "concurs_sali";
    $tblSaliConcurs->name = 'Sali de concurs';
    $tblSaliConcurs->AddField("ID", "id", "number", true, true, false, false);
    $tblSaliConcurs->AddField("id_concurs", 'id_concurs', "number");
    $tblSaliConcurs->fields['id_concurs']->defaultValue = $default_id_concurs;
    $tblSaliConcurs->AddField('Sala', 'sala', 'string');
    $tblSaliConcurs->AddField('Locuri', 'locuri', 'number');
    $tblSaliConcurs->AddField('Prioritate', 'prioritate', 'number');

    // actions
    $tblEleviConcurs = new TTable('tblEleviConcurs');
    $tblEleviConcurs->tableName = "concurs_elevi";
    $tblEleviConcurs->name = 'Elevi';
    $tblEleviConcurs->AddField("ID", "id", "number", true, true, false, false);
    $tblEleviConcurs->AddRequiredField('Nume și prenume', 'nume', 'string');
    $tblEleviConcurs->AddField('id_concurs', 'id_concurs', 'number', false, true, false, false);
    $tblEleviConcurs->fields['id_concurs']->defaultValue = $default_id_concurs;
    $tblEleviConcurs->AddForeignField('Clasa', 'id_clasa_concurs', 'number',
        $tblClaseConcurs, 'id', 'clasa', 'select', false, false);
    $tblEleviConcurs->AddForeignField('Sala', 'id_sala_concurs', 'number',
        $tblSaliConcurs, 'id', 'sala', 'select', false, false, false);
    $tblEleviConcurs->AddField('Școala', 'scoala', 'string');
    $tblEleviConcurs->AddField('Adresa', 'adresa', 'string', false, false, false);
    $tblEleviConcurs->AddField('Profesor coordonator', 'profesor_coordonator', 'string', false, false, false);
    $tblEleviConcurs->AddField('Punctaj', 'punctaj', 'number', false, false, true, true, true);
    $tblEleviConcurs->AddField('Premiu obținut', 'premiu', 'string');
    $tblEleviConcurs->sqlWhere = "(`concurs_elevi`.`id_concurs` = $default_id_concurs)";
    $tblEleviConcurs->sqlOrder = 'nume ASC';

    $tblEleviConcurs->fields['nume']->gridWidth = 180;
    $tblEleviConcurs->fields['id_clasa_concurs']->gridWidth = 75;
    $tblEleviConcurs->fields['scoala']->gridWidth = 100;
    $tblEleviConcurs->fields['punctaj']->gridWidth = 50;
    $tblEleviConcurs->fields['premiu']->gridWidth = '*';

?>